<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - Elétrica</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper es-eletrica">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">Elétrica</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#" class="home"><span>Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Especialidades</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">Elétrica</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">


			<!-- Candidate  Details-->
			<section class="section-lg">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<div class="row align-items-center">
								<div class="col-md-12 col-lg-4">
									<div class="pbmit-team-details-inner">
										<div class="pbmit-team-img">
											<img src="{{ asset('assets/images/specialty/eletrica.webp') }}"
												class="w-100" alt="">
										</div>
									</div>
								</div>
								<div class="col-md-12 col-lg-8">
									<div class="pbmit-team-summary">
										<h4 class="pbmit-team-designation">Especialidade</h4>
										<h2 class="pbmit-team-title">Elétrica</h2>
										<p>
											A perícia em elétrica representa uma <strong>especialização</strong>
											dedicada à investigação
											e análise de incidentes relacionados à eletricidade. Essa área abrange uma
											extensa variedade de situações, que vão desde incêndios elétricos até
											acidentes envolvendo eletricidade e falhas em sistemas elétricos, entre
											outros eventos associados à energia elétrica.
										</p>
										<p>
											Nosso time de peritos é composto por <strong>profissionais
												experientes</strong> na condução
											de perícias de engenharia, com foco no estudo aprofundado de falhas e
											acidentes em equipamentos elétricos e eletrônicos. Esses especialistas
											possuem <strong>conhecimento técnico sólido</strong> e uma vasta experiência
											prática,
											garantindo uma abordagem abrangente e precisa em cada investigação.
										</p>
										<p>
											Ao realizar perícias, nosso objetivo é identificar as causas raiz dos
											incidentes, analisar minuciosamente os componentes elétricos envolvidos e
											fornecer relatórios detalhados que possam ser utilizados para esclarecimento
											de responsabilidades, melhorias em sistemas e prevenção de futuros eventos
											adversos.
										</p>
										<p>
											A expertise de nosso time aliada à utilização de <strong>tecnologias avançadas</strong> de
											análise e instrumentação nos posiciona como referência no campo da perícia
											em elétrica, assegurando a qualidade e confiabilidade em cada avaliação
											realizada.
										</p>
										<p>
											<strong>Veja como podemos ajuda-lo!</strong>
										<ul>
											<li>- Sinistros Residenciais e Empresariais;</li>
											<li>- Usinas Geradoras;</li>
											<li>- Transformadores;</li>
											<li>- Usinas Solar e eólica.</li>
										</ul>
										</p>
									</div>
								</div>
							</div>

						</div>
					</div>
				</div>
			</section>
			<!-- Candidate  Details end -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-specialty").addClass("active");
	</script>
</body>

</html>
