<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Soluções em Sinistros</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    @include('br.partials.style')
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">
    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        @include('br.partials.top-bar')
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            @include('br.partials.menu')
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="pbmit-slider-area">
            <!-- DESKTOP -->
            <div class="d-none d-sm-block">
                <ul class="rslides" id="slider1">
                    <li>
                        <img src="{{ asset('assets/images/slideshow/banner-pilares-1920x500px.webp') }}"
                             alt="">
                    </li>
                    <li>
                        <img src="{{ asset('assets/images/slideshow/banner-institucional-1920x500px.webp') }}"
                             alt="pilares">
                    </li>
                    <li>
                        <img src="{{ asset('assets/images/slideshow/banner-servicos-1920x500px.webp') }}"
                             alt="pilares">
                    </li>
                    <li>
                        <img src="{{ asset('assets/images/slideshow/banner-especialidades-1920x500px.webp') }}"
                             alt="pilares">
                    </li>
                </ul>
            </div>
            <!-- ./DESKTOP -->

            <!-- MOBILE -->
            <div id="carouselExampleAutoplaying" class="carousel slide d-block d-sm-none" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <img src="{{ asset('assets/images/slideshow/mobile/banner-especialidades-500x500px.png') }}"
                             class="d-block w-100" alt="...">
                    </div>
                    <div class="carousel-item">
                        <img src="{{ asset('assets/images/slideshow/mobile/banner-institucional-500x500px.png') }}"
                             class="d-block w-100" alt="...">
                    </div>
                    <div class="carousel-item">
                        <img src="{{ asset('assets/images/slideshow/mobile/banner-pilares-500x500px.png') }}"
                             class="d-block w-100" alt="...">
                    </div>
                    <div class="carousel-item">
                        <img src="{{ asset('assets/images/slideshow/mobile/banner-servicos-500x500px.png') }}"
                             class="d-block w-100" alt="...">
                    </div>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleAutoplaying"
                        data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleAutoplaying"
                        data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>

            <!-- ./MOBILE -->
        </div>
    </header>
    <!-- Header Main Area End Here -->

    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">
        <!-- About start -->
        <section class="section-lg active-onhover" style="background-color: #fff;">
            <div class="container">
                <div class="about-content-one">
                    <div class="row">
                        <div class="col-md-6">
                            <img src="{{ asset('assets/images/about.png') }}" class="img-about-home" alt="a">
                        </div>
                        <div class="col-md-6">
                            <div class="pbmit-heading-subheading">
                                <h4 class="pbmit-subtitle">Quem Somos</h4>
                                <h3>Somos uma empresa de desenvolvimento de <span>Soluções</span> e Sinistros.</h3>
                                <p>Fundada em 1997 pelo engenheiro industrial metalúrgico José
                                    Candido de Oliveira Filho, a Tradsul é uma empresa brasileira
                                    <strong>especializada</strong> em consultoria e perícia
                                    técnica.
                                </p>
                                <div class="text-start">
                                    <p>
                                        <a href="{{ url('historia') }}" class="pbmit-btn pbmit-btn-hover-secondary">
                                            <span>Leia mais</span>
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- About End -->

        <!-- Expertise Start -->
        <section class="expertise-bg_color">
            <div class="container g-0">
                <div class="row g-0">
                    <div class="col-xl-5 col-lg-12">
                        <div class="expertise-bg-box">
                            <div class="pbmit-heading-subheading text-right">
                                <h4 class="pbmit-subtitle">Experiências</h4>
                                <h2 class="pbmit-title">Processos Concluídos</h2>
                            </div>
                            <p>Durante a sua jornada, a Tradsul acumula mais de 5.000 processos de perícia técnica
                                concluídos, dentro das suas áreas de competência.</p>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="pbminfotech-ele-fid-style-1">
                                        <div class="pbmit-fld-contents">
                                            <div class="pbmit-sbox-icon-wrapper">
                                                <i class="fas fa-star"></i>
                                            </div>
                                            <div class="pbmit-fld-wrap">
                                                <h4 class="pbmit-fid-inner">
														<span class="pbmit-number-rotate numinate"
                                                              data-appear-animation="animateDigits" data-from="0"
                                                              data-to="5500" data-interval="5" data-before=""
                                                              data-before-style="" data-after=""
                                                              data-after-style="">5500</span> <span
                                                        class="pbmit-fid"><sup>+</sup></span>
                                                </h4>
                                                <div class="pbmit-fid-title">
                                                    <span>Processos Concluídos</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-12">
                        <div class="trunck-img-box"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Expertise End -->

        <!-- Portfolio Start -->
        <section class="section-lgt portfolio-bg-one">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="pbmit-heading-subheading">
                            <h4 class="pbmit-subtitle text-white">Cases</h4>
                            <h2 class="pbmit-title text-white">Conheça nossos cases de sucesso</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="swiper-slider button-with-text" data-loop="true" data-autoplay="true" data-dots="true"
                 data-arrows="false" data-columns="5" data-margin="30" data-effect="slide">
                <div class="swiper-wrapper">

                    <div class="swiper-slide">
                        <!-- slide 1 -->
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/incendio.webp') }}"
                                         class="img-fluid" alt="...">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Incêndio</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a
                                                href="{{ url('cases')  }}">
                                                Incêndio em Shopping Center
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>

                    <!-- slide 2 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/explosao.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Explosao</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Explosão em restaurantes
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 3 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/incendio-2.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Incêndio</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Incêndio em fábrica de tecidos
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 4 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/incendio-3.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Incêndio</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Equipamento em Recall
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 5 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/incendio-4.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Incêndio</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                O Perigo nos grãos armazenados
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 6 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/eletrica.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Elétrica</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Incêndio de grandes proporções em Centro de Distribuição
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 7 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/explosao-2.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Explosão</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Explosão em gasômetro
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!-- slide 8 -->
                    <div class="swiper-slide">
                        <article class="pbmit-portfolio-style-1">
                            <div class="pbminfotech-post-content">
                                <div class="pbmit-featured-wrapper">
                                    <img src="{{ url('assets/images/cases/incendio-5.webp') }}"
                                         class="img-fluid" alt="">
                                </div>
                                <div class="pbminfotech-box-content">
                                    <div class="pbminfotech-titlebox">
                                        <div class="pbmit-port-cat">
                                            <a href="{{ url('cases') }}"
                                               rel="tag">Incêncio</a>
                                        </div>
                                        <h3 class="pbmit-portfolio-title">
                                            <a href="{{ url('cases') }}">
                                                Incêndio de grandes proporções em comercio popular
                                            </a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
            </div>
        </section>
        <!-- Portfolio End -->

        <!-- Service -->
        <section class="section-lg_tb">
            <div class="container">
                <div class="pbmit-heading-subheading text-center">
                    <h4 class="pbmit-subtitle"></h4>
                    <h2 class="pbmit-title">Nossas Especialidades</h2>
                </div>
                <div class="swiper-slider" data-arrows-class="false" data-autoplay="false" data-dots="true"
                     data-arrows="false" data-columns="3" data-margin="30" data-effect="slide">
                    <div class="swiper-wrapper">
                        <!-- slide 1 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/incendio-explosao') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/banner-incendio-770x635px.png') }}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="{{ url('especialidade/incendio-explosao') }}"
                                                   rel="tag">Incêndio e Explosão</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a href="#">Incêndio e Explosão</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>A perícia em incêndio e explosão se concentra na investigação e
                                                    análise
                                                    de incêndios e explosões para determinar suas
                                                    causas,
                                                    origens e
                                                    respectivos danos...
                                                </p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/inceidio-explosao') }}">Saiba
                                                    mais</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- slide 2 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/eletrica') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/banner-eletrica-770x635px.png') }}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="{{ url('especialidade/eletrica') }}"
                                                   rel="tag">Elétrica</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a href="#">Elétrica</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>A perícia em elétrica é uma especialização que se dedica à
                                                    investigação e
                                                    análise de incidentes relacionados à eletricidade...</p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/eletrica') }}">Saiba
                                                    mais</a>
                                            </div>
                                            <br>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- slide 3 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/civil') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/banner-civil-770x635px.png')}}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="{{ url('especialidade/civil')}}"
                                                   rel="tag">Civil</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a href="#">Civil</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>
                                                    A perícia em engenharia civil representa uma especialização
                                                    crucial no
                                                    campo da engenharia, dedicada à avaliação e análise técnica de
                                                    questões
                                                    relacionadas...
                                                </p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/civil')}}">Saiba
                                                    mais</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- slide 4 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/mecanica') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/bannermecanica-770x635px.png')}}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="{{ url('especialidade/mecanica') }}"
                                                   rel="tag">Mecânica</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a href="#">Mecânica</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>A perícia em engenharia mecânica desempenha um papel crucial
                                                    tanto no
                                                    âmbito jurídico quanto na indústria, sendo responsável por
                                                    investigar...</p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/mecanica') }}">Saiba
                                                    mais</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- slide 5 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/quimica') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/banner-quimica-770x635px.png')}}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="{{ url('especialidade/quimica') }}"
                                                   rel="tag">Química</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a href="#">Química</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>A perícia em engenharia química é dedicada à análise técnica e
                                                    científica
                                                    de questões relacionadas a processos químicos, produtos
                                                    químicos,
                                                    reações químicas...</p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/quimica') }}">Saiba
                                                    mais</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- slide 6 -->
                        <div class="swiper-slide">
                            <article class="pbmit-service-style-4">
                                <div class="pbminfotech-post-item">
                                    <div class="pbmit-service-img-wrapper">
                                        <div class="pbmit-featured-wrapper">
                                            <a
                                                href="{{ url('especialidade/siderurgia') }}">
                                                <img
                                                    src="{{ url('assets/images/cards/specialty/banner-siderurgia-770x635px.png')}}"
                                                    class="img-fluid" alt="">
                                            </a>
                                        </div>
                                        <div class="pbmit-service-cat">
                                            <h4><a href="?php echo base_url('especialidade/siderurgia') }}"
                                                   rel="tag">Siderurgia</a></h4>
                                        </div>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-box-content-inner">
                                            <div class="pbmit-service-icon-wrapper">
                                                <i class="pbmit-colza-icon pbmit-colza-icon-mechanical-arm"></i>
                                            </div>
                                            <h3 class="pbmit-service-title">
                                                <a
                                                    href="{{ url('especialidade/siderurgia') }}">Siderurgia</a>
                                            </h3>
                                            <div class="pbmit-service-content">
                                                <p>A perícia em siderurgia é dedicada à investigação, análise e
                                                    avaliação de
                                                    questões técnicas relacionadas à produção e processamento de
                                                    metais e
                                                    aço...</p>
                                            </div>
                                            <div class="pbmit-service-btn">
                                                <a class="btn-arrow"
                                                   href="{{ url('especialidade/siderurgia') }}">Saiba
                                                    mais</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Service End -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    @include('br.partials.footer')
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
@include('br.partials.scripts')
<script>
    $(".mn-home").addClass("active");
</script>
</body>

</html>
