<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - Valores</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper values">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">Valores</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#" class="home"><span>Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Quem Somos</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">Valores</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">

			<!-- Our History -->
			<section class="section-lg active-onhover">
				<div class="container">
					<div class="about-content-one">
						<div class="row">
							<div class="col-md-12">
								<div class="pbmit-heading-subheading">
									<h4 class="pbmit-subtitle"></h4>
									<h2 class="pbmit-title">Nossos Valores</h2>
								</div>
							</div>
							<article class="pbmit-miconheading-style-11 col-md-4 col-lg-12">
								<div class="pbmit-ihbox pbmit-ihbox-style-1">
									<div class="pbmit-ihbox-box">
										<div class="pbmit-ihbox-icon">
											<div class="pbmit-ihbox-icon-wrapper">
												<i class="pbmit-colza-icon pbmit-colza-icon-miner"></i>
											</div>
										</div>
										<div class="pbmit-ihbox-contents">
											<!-- <h4 class="pbmit-element-subtitle">Explore the features</h4> -->
											<h2 class="pbmit-element-title">Missão</h2>
											<div class="pbmit-heading-desc">
												<p>Nossa missão é fornecer soluções de <strong>alta qualidade</strong>
													no segmento de
													sinistros para o mercado de seguros, adaptando nossos serviços às
													necessidades específicas de cada cliente.</p>
												<p>
													Comprometemo-nos com a <strong>capacidade técnica, agilidade e
														capilaridade</strong>,
													pois acreditamos que, por meio do nosso trabalho, podemos impactar
													positivamente cada sinistro em que atuamos, gerando valor duradouro
													para nossos stakeholders.
												</p>
												<p>
													Buscamos constantemente <strong>superar as expectativas</strong>,
													mantendo-nos
													atualizados com as melhores práticas do setor e aplicando nossa
													expertise para transformar desafios em oportunidades. Dessa forma,
													consolidamos nossa posição como <strong>parceiros
														confiáveis</strong>, promovendo a
													confiança e a satisfação de nossos clientes.
												</p>
												<p>
													Ao unir a eficiência operacional à personalização de serviços,
													estamos determinados a oferecer uma <strong>experiência
														excepcional</strong> em
													gestão de sinistros, contribuindo para a segurança financeira e a
													tranquilidade de nossos clientes. Nosso compromisso vai além da
													resolução eficaz; aspiramos a ser catalisadores de mudanças
													positivas em cada cenário de sinistro, agregando valor tanto aos
													segurados quanto às seguradoras.
												</p>
												<p>
													Com alicerces sólidos de <strong>integridade, inovação e
														responsabilidade</strong>,
													estamos prontos para enfrentar os desafios do setor de seguros,
													mantendo nosso foco na excelência e na criação de soluções
													personalizadas que impulsionem o sucesso mútuo a longo prazo.
												</p>
											</div>
										</div>
									</div>
								</div>
							</article>
							<article class="pbmit-miconheading-style-11 col-md-6 col-lg-6">
								<div class="pbmit-ihbox pbmit-ihbox-style-1" style="min-height: 570px;">
									<div class="pbmit-ihbox-box">
										<div class="pbmit-ihbox-icon">
											<div class="pbmit-ihbox-icon-wrapper">
												<i class="pbmit-colza-icon pbmit-colza-icon-weight-scale"></i>
											</div>
										</div>
										<div class="pbmit-ihbox-contents">
											<h2 class="pbmit-element-title">
												Visão
											</h2>
											<div class="pbmit-heading-desc">
												<p>
													Buscamos o reconhecimento como <strong>líderes em capacidade
														técnica</strong> na
													análise de sinistros, assegurando a entrega de relatórios com
													qualidade e agilidade para agregar valor aos processos dos nossos
													clientes.
												</p>
												<p>
													Almejamos ser uma empresa que <strong>inspira e capacita</strong>
													seus colaboradores,
													promovendo um ambiente de trabalho colaborativo, inclusivo,
													gratificante e sustentável. Acreditamos que ao investir no
													desenvolvimento e bem-estar de nossa equipe, fortalecemos não apenas
													a empresa, mas também o comprometimento e a excelência em cada
													projeto que empreendemos.
												</p>
												<p>Nossa visão transcende a prestação de serviços; desejamos ser
													reconhecidos não apenas pela eficiência em nossas operações, mas
													também pelo <strong>impacto positivo</strong> que causamos no
													desenvolvimento
													profissional e pessoal de nossos colaboradores. Ao promover uma
													cultura organizacional que valoriza a diversidade, a inovação e a
													colaboração, estamos construindo a base para o sucesso sustentável
													de nossa equipe e, por consequência, para o êxito contínuo de nossos
													clientes.</p>
											</div>
										</div>
									</div>
								</div>
							</article>
							<article class="pbmit-miconheading-style-11 col-md-6 col-lg-6">
								<div class="pbmit-ihbox pbmit-ihbox-style-1">
									<div class="pbmit-ihbox-box">
										<div class="pbmit-ihbox-icon">
											<div class="pbmit-ihbox-icon-wrapper">
												<i class="pbmit-colza-icon pbmit-colza-icon-gold-ingots"></i>
											</div>
										</div>
										<div class="pbmit-ihbox-contents">
											<h2 class="pbmit-element-title">
												Valores
											</h2>
											<div class="pbmit-heading-desc">
												<ul>
													<li><strong>Capacidade Técnica</strong> <br> Investimos muito em
														nosso time para que nossas análises sejam sempre assertivas.
													</li>
													<li><strong>Agilidade</strong> <br> Entendemos como agilidade a
														resposta correta e no tempo exato que sua empresa necessita.
													</li>
													<li><strong>Capilaridade</strong> <br> Nossa capacidade de
														atendimento em todo o território nacional traz a segurança que
														nossos clientes precisam para os momentos mais críticos do
														processo de Sinistro.</li>
													<li><strong>Honestidade</strong> <br> Agimos com integridade,
														transparência e ética em todas as nossas operações.</li>
													<li><strong>Responsabilidade Social</strong> <br> Participamos de
														diversos programas de voluntariado a grupos menos providos em
														nossa região.</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</article>
						</div>
					</div>
				</div>
			</section>
			<!-- Our History End -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-about").addClass("active");
	</script>
</body>

</html>
