<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Civil</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    @include('en.partials.style')
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">

    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        @include('en.partials.top-bar')
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            @include('en.partials.menu')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Main Area End Here -->


    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper es-civil">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner">
                            <h1 class="pbmit-tbar-title text-white">Civil</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a title="" href="#" class="home"><span>Home</span></a></span>
                            <span class="sep">-</span>
                            <span><span>Work Area</span></span>
                            <span class="sep">-</span>
                            <span><span class="post-root post post-post current-item">Civil</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Title Bar End-->


    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">


        <!-- Candidate  Details-->
        <section class="section-lg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row align-items-center">
                            <div class="col-md-12 col-lg-4">
                                <div class="pbmit-team-details-inner">
                                    <div class="pbmit-team-img">
                                        <img src="{{ url('assets/images/specialty/civil.webp') }}"
                                             class="w-100" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-8">
                                <div class="pbmit-team-summary">
                                    <h4 class="pbmit-team-designation">Work Area</h4>
                                    <h2 class="pbmit-team-title">Civil</h2>
                                    <p>
                                        Civil engineering expertise is a crucial specialty in the field of engineering,
                                        dedicated to the technical evaluation and analysis of issues related to
                                        construction projects, buildings, infrastructure, and other civil works.
                                    </p>
                                    <p>
                                        This area plays a fundamental role in contexts involving legal disputes,
                                        construction quality problems, structural damage, construction accidents, and
                                        civil liability issues. Civil engineering experts apply their technical
                                        knowledge to investigate and provide precise analyses in situations requiring a
                                        detailed understanding of construction aspects, relevant codes, and regulations.
                                    </p>
                                    <p>
                                        The expertise of these professionals is essential to ensure the integrity of
                                        structures, prevent catastrophic failures, and resolve disputes fairly and
                                        impartially. Their contribution is valuable not only in preventing problems but
                                        also in effectively resolving issues arising from construction, playing a
                                        crucial role in maintaining the safety and quality of civil structures.
                                    </p>
                                    <p>

                                    </p>
                                    <p>
                                        <strong>Here’s how we can assist you!</strong>
                                    <ul>
                                        <li>- Residential and Commercial Claims.</li>
                                        <li>- Condominiums.</li>
                                        <li>- Power Plants.</li>
                                        <li>- Transformers.</li>
                                        <li>- Solar and Wind Farms.</li>
                                    </ul>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <!-- Candidate  Details end -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    @include('en.partials.footer')
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
@include('en.partials.scripts')
<script>
    $(".mn-specialty").addClass("active");
</script>
</body>

</html>
