<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Mechanical</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    @include('en.partials.style')
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">

    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        @include('en.partials.top-bar')
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            @include('en.partials.menu')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Main Area End Here -->


    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper es-mecanica">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner">
                            <h1 class="pbmit-tbar-title text-white">Mechanical</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a title="" href="#" class="home"><span>Home</span></a></span>
                            <span class="sep">-</span>
                            <span><span>Work Area</span></span>
                            <span class="sep">-</span>
                            <span><span class="post-root post post-post current-item">Mechanical</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Title Bar End-->


    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">


        <!-- Candidate  Details-->
        <section class="section-lg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row align-items-center">
                            <div class="col-md-12 col-lg-4">
                                <div class="pbmit-team-details-inner">
                                    <div class="pbmit-team-img">
                                        <img src="{{ asset('assets/images/specialty/mecanica.webp') }}"
                                             class="w-100" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-8">
                                <div class="pbmit-team-summary">
                                    <h4 class="pbmit-team-designation">Work Area</h4>
                                    <h2 class="pbmit-team-title">Mechanical</h2>
                                    <p>
                                        Mechanical engineering expertise plays a crucial role both in the legal field
                                        and in industry, being responsible for investigating and analyzing technical
                                        issues related to systems, machines, equipment, and mechanical components.
                                    </p>
                                    <p>
                                        We have a team of highly qualified experts specialized in conducting engineering
                                        expertise, dedicated to studying failures and accidents in a wide range of
                                        machines and equipment. Examples include wind turbines, hydraulic turbines,
                                        motor generators, compressors, among others. Our work encompasses identifying
                                        the root cause, assessing material damage, and determining the associated risk
                                        value.
                                    </p>
                                    <p>
                                        These professionals, with solid experience in mechanical engineering, apply
                                        advanced analytical methods to provide accurate and detailed assessments.
                                        Whether in the legal context, to support legal processes, or in the industry, to
                                        improve operational efficiency and ensure safety, our team of experts is
                                        committed to offering reliable technical solutions and contributing to the
                                        effective resolution of issues related to machines and mechanical equipment.
                                    </p>
                                    <p>
                                        <strong>See how we can help you!</strong>
                                    <ul>
                                        <li>- Residential and Business Claims;</li>
                                        <li>- Power Plants;</li>
                                        <li>- Transformers;</li>
                                        <li>- Solar and Wind Farms;</li>
                                    </ul>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <!-- Candidate  Details end -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    @include('en.partials.footer')
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
@include('en.partials.scripts')
<script>
    $(".mn-specialty").addClass("active");
</script>
</body>

</html>
